# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#####################################################################
#                                                                   #
# Module:  InstallDefs.pm                                           #
#                                                                   #
#                                                                   #
# Description:   This module contains subroutines and definitions   #
#             that are used by multiple other commands.             #
#                                                                   #
# Subroutines:                                                      #
#                                                                   #
# Notes:                                                            #
#                                                                   #
#####################################################################
# @(#)54   1.87   src/csm/install/InstallDefs.pm.perl, setup, csm_rpyxh, rpyxht1f3 9/5/02 15:58:14

package InstallDefs;

BEGIN  {
    use File::Basename;      # - this gives us the path of the command
    ($::Bin) = dirname($0);  # - for this command we assume the modules and 
                             #     message maps are in the same place
}
use lib "$::Bin";

use NodeUtils;


#-------------------------------------------------------------------
#    Global Definitions
#-------------------------------------------------------------------

$::NOK=1;
$::OK=0;

$::LS         =  "/bin/ls";
$::MOVE       =  "/bin/mv";
$::LN         =  "/bin/ln";
$::RM         =  "/bin/rm";
$::MV         =  "/bin/mv";
$::CAT        =  "/bin/cat";
$::MKDIR      =  "/bin/mkdir";
$::CHMOD      =  "/bin/chmod";
$::COPY       =  "/bin/cp";
$::EXPORTFS   =  "/usr/sbin/exportfs";
$::RPMCMD     =  "/bin/rpm";
$::UNAME      =  "/bin/uname";
$::CSMTOP     = "/opt/csm";
$::CSMREQS    = $::CSMTOP  . "/reqs";
$::CSMBIN     = $::CSMTOP  . "/bin";
$::CSMCSMBIN  = $::CSMTOP  . "/csmbin";
$::DSH        = $::CSMBIN  . "/dsh";
$::ADDLCSEXT  = $::CSMBIN . "/addlcsext";
$::UPDATENODE = $::CSMBIN  . "/updatenode";
$::CREATENODE = $::CSMCSMBIN . "/createnode";
$::ATFTP      = "/usr/bin/atftp";
$::LSOF       = "/usr/sbin/lsof";
$::ESPTTY     = "/usr/bin/esptty";
$::GREP       = "/bin/grep";
$::TOUCH      = "/bin/touch";
$::SLEEP      = "/bin/sleep";
$::GUNZIP     = "/bin/gunzip";
$::GZIP       = "/bin/gzip";
$::IFCONFIG   = "/sbin/ifconfig";
$::NETSTAT    = "/bin/netstat";
$::TAIL       = "/usr/bin/tail";
$::TAR        = "/bin/tar";




$::TFTPBOOT   			= "/tftpboot";
$::PXELINUX_CFG_DIR     = "/tftpboot/pxelinux.cfg";
$::RPOWER  		        = $::CSMBIN . "/rpower";
$::MONITORINSTALL       = $::CSMBIN . "/monitorinstall";

#csm commands
$::MKGETMACRD           = "/opt/csm/csmbin/mkgetmacrd";
$::GETMACS              = "/opt/csm/bin/getmacs";
$::CREATEDHCP           = "/opt/csm/csmbin/createdhcp";
$::UPDATEDHCP           = "/opt/csm/csmbin/updatedhcp";

$::CSM2NIMGRPS          = $::CSMBIN  . "/csm2nimgrps";
$::CSM2NIMNODES         = $::CSMBIN  . "/csm2nimnodes";
$::NODEGRP              = $::CSMBIN  . "/nodegrp";

# CSM definitions
$::LOGFILE_HANDLE        = undef;
$::CSMLOG                = "/var/log/csm";
$::CSMSETUPKS_LOG        = $::CSMLOG . "/csmsetupks.log";
$::INSTALLNODE_LOG       = $::CSMLOG . "/installnode.log";
$::MAKENODE_LOG          = $::CSMLOG . "/makenode.log";
$::UPDATENODE_LOG        = $::CSMLOG . "/updatenode.log";
$::CSMPREREBOOT_LOG      = $::CSMLOG . "/csmprereboot.log";
$::CSMFIRSTBOOT_LOG      = $::CSMLOG . "/csmfirstboot.log";
$::INSTALLMSLOG          = $::CSMLOG . "/installms.log";
$::INSTALL_LOG           = "/var/log/csm/install.log";

$::LSNODE                =  "/opt/csm/bin/lsnode";
$::CHNODE                =  "/opt/csm/bin/chnode";
$::MGMTSVR               =  "/opt/csm/bin/mgmtsvr";
$::CFORCE                =  "/opt/csm/bin/cfmupdatenode";
$::SMSUPDATENODE         =  "/opt/csm/bin/smsupdatenode";
$::CFGINFOFILE           =  "/opt/csm/install/configinfo";
$::CSMCFGDIR             =  "/csminstall/csm/config/";
$::NODEMAP_FILE          =  "$::CSMCFGDIR/nodemap";
$::CSMINSTDIR            =  "/csminstall";
$::OPTCSMINSTALL         =  "/opt/csm/install";
$::RMNODE                =  "/opt/csm/bin/rmnode";
$::REMOTESHELL_EXPECT	 =  "/opt/csm/csmbin/remoteshell.expect";

#$::PLTFRM 		 = InstallUtils->get_OSName();
if(NodeUtils->isLinux()==1){
	$::PLTFRM 		 = "Linux";
}
elsif(NodeUtils->isAIX()==1){
	$::PLTFRM 		 = "AIX";
}

# commands that are unique to an operating system
#   or are located in different places
if ($::PLTFRM eq "AIX") {

  $::MKNFS                 =  "/usr/sbin/mknfs";
  $::MOUNT                 =  "/usr/sbin/mount";
  $::UNMOUNT               =  "/usr/sbin/umount";
  $::PING                  =  "/etc/ping";
  $::INSTALLPCMD           =  "/usr/sbin/installp";
  $::MKITAB                =  "/usr/sbin/mkitab";
  $::RMITAB                =  "/usr/sbin/rmitab";
  $::LSITAB                =  "/usr/sbin/lsitab";
  $::NIMINFO               =  "/etc/niminfo";
  $::NIM                   =  "/usr/sbin/nim";
  $::LSNIM                 =  "/usr/sbin/lsnim";
  $::MKNFSEXP              =  "/usr/sbin/mknfsexp";
  $::LSRSRC                =  "/bin/lsrsrc";
  $::LSRSRC_API		       =  "/bin/lsrsrc-api";
  $::OSLEVEL               =  "/bin/oslevel";
  $::LSLPP                 =  "/bin/lslpp";
  $::HEAD                  =  "/bin/head";
  $::RESTORE               =  "/usr/sbin/restore";
  $::RPM2CPIO              =  "/bin/rpm2cpio";
  $::CUT                   =  "/usr/bin/cut";

} else {  # Linux versions

  $::SERVICE    =  "/sbin/service";
  $::MOUNT      =  "/bin/mount";
  $::UNMOUNT    =  "/bin/umount";
  $::PING       =  "/bin/ping";
  $::LSRSRC     =  "/usr/bin/lsrsrc";
  $::LSRSRC_API =  "/usr/bin/lsrsrc-api";
  $::HEAD       =  "/usr/bin/head";
  $::RPM2CPIO   =  "/usr/bin/rpm2cpio";

}

# these have the platform prefixed for interoperability


  $::AIX_MKNFS                 =  "/usr/sbin/mknfs";
  $::AIX_MOUNT                 =  "/usr/sbin/mount";
  $::AIX_UNMOUNT               =  "/usr/sbin/umount";
  $::AIX_PING                  =  "/etc/ping";
  $::AIX_INSTALLPCMD           =  "/usr/sbin/installp";
  $::AIX_MKITAB                =  "/usr/sbin/mkitab";
  $::AIX_RMITAB                =  "/usr/sbin/rmitab";
  $::AIX_LSITAB                =  "/usr/sbin/lsitab";
  $::AIX_NIMINFO               =  "/etc/niminfo";
  $::AIX_NIM                   =  "/usr/sbin/nim";
  $::AIX_LSNIM                 =  "/usr/sbin/lsnim";
  $::AIX_MKNFSEXP              =  "/usr/sbin/mknfsexp";
  $::AIX_LSRSRC                =  "/bin/lsrsrc";
  $::AIX_LSRSRC_API		       =  "/bin/lsrsrc-api";
  $::AIX_OSLEVEL               =  "/bin/oslevel";
  $::AIX_LSLPP                 =  "/bin/lslpp";
  $::AIX_HEAD                  =  "/bin/head";
  $::AIX_RESTORE               =  "/usr/sbin/restore";
  $::AIX_RPM2CPIO              =  "/bin/rpm2cpio";
  $::AIX_CUT                   =  "/usr/bin/cut";

  $::LINUX_SERVICE    =  "/sbin/service";
  $::LINUX_MOUNT      =  "/bin/mount";
  $::LINUX_UNMOUNT    =  "/bin/umount";
  $::LINUX_PING       =  "/bin/ping";
  $::LINUX_LSRSRC     =  "/usr/bin/lsrsrc";
  $::LINUX_LSRSRC_API =  "/usr/bin/lsrsrc-api";
  $::LINUX_HEAD       =  "/usr/bin/head";
  $::LINUX_RPM2CPIO   =  "/usr/bin/rpm2cpio";



# The human-readable name of the distribution
$::DISTRO_NAME{'RedHat 6.2'}    = "Red Hat Linux 6.2";
$::DISTRO_NAME{'RedHat 7.0'}    = "Red Hat Linux 7.0";
$::DISTRO_NAME{'RedHat 7.1'}    = "Red Hat Linux 7.1";
$::DISTRO_NAME{'RedHat 7.2'}    = "Red Hat Linux 7.2";
$::DISTRO_NAME{'RedHat 7.3'}    = "Red Hat Linux 7.3";

$::DISTRO_SHORTNAME{'RedHat 6.2'}       = "rh62";
$::DISTRO_SHORTNAME{'RedHat 7.0'}       = "rh70";
$::DISTRO_SHORTNAME{'RedHat 7.1'}       = "rh71";
$::DISTRO_SHORTNAME{'RedHat 7.2'}       = "rh72";
$::DISTRO_SHORTNAME{'RedHat 7.3'}       = "rh73";

$::DISTRO_SHORTNAMEKS{'RedHat 6.2'}     = "ks62";
$::DISTRO_SHORTNAMEKS{'RedHat 7.0'}     = "ks70";
$::DISTRO_SHORTNAMEKS{'RedHat 7.1'}     = "ks71";
$::DISTRO_SHORTNAMEKS{'RedHat 7.2'}     = "ks72";
$::DISTRO_SHORTNAMEKS{'RedHat 7.3'}     = "ks73";

# A list of numbers corresponding to the number of CD-ROMs in the distribution
$::DISTRO_DISKLIST{'RedHat 6.2'}        = "1";
$::DISTRO_DISKLIST{'RedHat 7.0'}        = "1 2";
$::DISTRO_DISKLIST{'RedHat 7.1'}        = "1 2";
$::DISTRO_DISKLIST{'RedHat 7.2'}        = "1 2";
$::DISTRO_DISKLIST{'RedHat 7.3'}        = "1 2 3";

# The directory under which the RPMs reside on the RedHat distribution CD-ROM(s)
$::DISTRO_RPMDIR{'RedHat 6.2'}  = "RedHat/RPMS";
$::DISTRO_RPMDIR{'RedHat 7.0'}  = "RedHat/RPMS";
$::DISTRO_RPMDIR{'RedHat 7.1'}  = "RedHat/RPMS";
$::DISTRO_RPMDIR{'RedHat 7.2'}  = "RedHat/RPMS";
$::DISTRO_RPMDIR{'RedHat 7.3'}  = "RedHat/RPMS";

# List of supported distributions
@::VALID_DISTROS  = (
                  'RedHat 6.2',
                  'RedHat 7.0',
                  'RedHat 7.1',
                  'RedHat 7.2',
                  'RedHat 7.3',
                  );
@::VALID_AIX_DISTROS = (
                  'AIX5.1',
                  'AIX5.1.0',
                  'AIX5.2',
                  'AIX5.2.0',
                  );
@::VALID_CSM_DISTROS = (
		  '1.1.0',
                  '1.2.0',
                  '1.3.0'
                  );


$::DISTRO = "";
@::valid_powermethod=();
@::valid_console=();



#####################################################################
# Open Source Pre-requisities
# assighing $opensrc_prereqs{<filesetname>}
#			    {<oslevel&version>}
#			    {<fileset version>}=[<List of prerequists>]
#####################################################################

# CSM.CORE

# Linux

$::opensrc_prereqs{'csm.core'}{'LinuxRedHat7.3'}{'1.2.0'} = [];
$::opensrc_prereqs{'csm.core'}{'LinuxRedHat7.2'}{'1.2.0'} = [];
$::opensrc_prereqs{'csm.core'}{'LinuxRedHat7.1'}{'1.2.0'} = [];
$::opensrc_prereqs{'csm.core'}{'LinuxRedHat7.3'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.core'}{'LinuxRedHat7.2'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.core'}{'LinuxRedHat7.1'}{'1.3.0'} = [];

# AIX

$::opensrc_prereqs{'csm.core'}{'AIX5.1'}{'1.1.0'} = [];
$::opensrc_prereqs{'csm.core'}{'AIX5.1.0'}{'1.1.0'} = [];
$::opensrc_prereqs{'csm.core'}{'AIX5.1'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.core'}{'AIX5.1.0'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.core'}{'AIX5.2'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.core'}{'AIX5.2.0'}{'1.3.0'} = [];

# CSM.SERVER

# Linux

$::opensrc_prereqs{'csm.server'}{'LinuxRedHat7.3'}{'1.2.0'} 
			= ['atftp','syslinux','IBMJava2-JRE-1.3'];
$::opensrc_prereqs{'csm.server'}{'LinuxRedHat7.2'}{'1.2.0'} 
			= ['atftp','syslinux','IBMJava2-JRE-1.3'];
$::opensrc_prereqs{'csm.server'}{'LinuxRedHat7.1'}{'1.2.0'} 
			= ['atftp','syslinux','IBMJava2-JRE-1.3'];
$::opensrc_prereqs{'csm.server'}{'LinuxRedHat7.3'}{'1.3.0'} 
		= ['atftp','syslinux','IBMJava2-JRE-1.3','conserver'];
$::opensrc_prereqs{'csm.server'}{'LinuxRedHat7.2'}{'1.3.0'} 
		= ['atftp','syslinux','IBMJava2-JRE-1.3','conserver'];
$::opensrc_prereqs{'csm.server'}{'LinuxRedHat7.1'}{'1.3.0'} 
		= ['atftp','syslinux','IBMJava2-JRE-1.3','conserver'];

# AIX
$::opensrc_prereqs{'csm.server'}{'AIX5.1'}{'1.1.0'} = [];
$::opensrc_prereqs{'csm.server'}{'AIX5.1.0'}{'1.1.0'} = [];
$::opensrc_prereqs{'csm.server'}{'AIX5.1'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.server'}{'AIX5.1.0'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.server'}{'AIX5.2'}{'1.3.0'} = ['openCIMOM-0.7*','tcl*','tk*','expect*','conserver*']; 
$::opensrc_prereqs{'csm.server'}{'AIX5.2.0'}{'1.3.0'} = ['openCIMOM-0.7*','tcl*','tk*','expect*','conserver*']; 

# CSM.CLIENT

# Linux

$::opensrc_prereqs{'csm.client'}{'LinuxRedHat7.3'}{'1.2.0'} = [];
$::opensrc_prereqs{'csm.client'}{'LinuxRedHat7.2'}{'1.2.0'} = [];
$::opensrc_prereqs{'csm.client'}{'LinuxRedHat7.1'}{'1.2.0'} = [];
$::opensrc_prereqs{'csm.client'}{'LinuxRedHat7.3'}{'1.3.0'} 
			= ['perl-libnet','autoupdate'];
$::opensrc_prereqs{'csm.client'}{'LinuxRedHat7.2'}{'1.3.0'} 
			= ['perl-libnet','autoupdate'];
$::opensrc_prereqs{'csm.client'}{'LinuxRedHat7.1'}{'1.3.0'} 
			= ['perl-libnet','autoupdate'];

# AIX
$::opensrc_prereqs{'csm.client'}{'AIX5.1'}{'1.1.0'} = [];
$::opensrc_prereqs{'csm.client'}{'AIX5.1.0'}{'1.1.0'} = [];
$::opensrc_prereqs{'csm.client'}{'AIX5.1'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.client'}{'AIX5.1.0'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.client'}{'AIX5.2'}{'1.3.0'} = [];
$::opensrc_prereqs{'csm.client'}{'AIX5.2.0'}{'1.3.0'} = [];




#####################################################################
# These are only used by installms and csmcopypkgs for copying, 
# not for installing.
#####################################################################

$::opensrc_prereqs{'csm.director.agent'}{'LinuxRedHat7.3'}{'1.2.0'} = [];
$::opensrc_prereqs{'csm.director.agent'}{'LinuxRedHat7.2'}{'1.2.0'} = [];
$::opensrc_prereqs{'csm.director.agent'}{'LinuxRedHat7.1'}{'1.2.0'} = [];
$::opensrc_prereqs{'csm.director.agent'}{'LinuxRedHat7.3'}{'1.3.0'} 
						= ['ITDAgent'];
$::opensrc_prereqs{'csm.director.agent'}{'LinuxRedHat7.2'}{'1.3.0'} 
						= ['ITDAgent'];
$::opensrc_prereqs{'csm.director.agent'}{'LinuxRedHat7.1'}{'1.3.0'} 
						= ['ITDAgent'];

#####################################################################
# Management Server rsct & csm packages
# assigning $rsct_packages/$csm_packages{<MgmtSvr>}{<oslevel&version>}
#			{<fileset version>}=[<List of prerequists>]
#####################################################################

# Linux

$::rsct_packages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.2.0'}
			=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.2.0'}
			=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.2.0'}
			=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.3.0'}
			=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.3.0'}
			=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.3.0'}
			=['src','rsct.core.utils','rsct.core'];

# AIX

$::rsct_packages{'MgmtSvr'}{'AIX5.1'}{'1.1.0'}=[];
$::rsct_packages{'MgmtSvr'}{'AIX5.1.0'}{'1.1.0'}=[];
$::rsct_packages{'MgmtSvr'}{'AIX5.1'}{'1.3.0'}=[];
$::rsct_packages{'MgmtSvr'}{'AIX5.1.0'}{'1.3.0'}=[];
$::rsct_packages{'MgmtSvr'}{'AIX5.2'}{'1.3.0'}=[];
$::rsct_packages{'MgmtSvr'}{'AIX5.2.0'}{'1.3.0'}=[];

# Linux

$::csm_packages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.2.0'}=['csm.core','csm.dsh','csm.server','csm.gui.dcem'];
$::csm_packages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.2.0'}=['csm.core','csm.dsh','csm.server','csm.gui.dcem'];
$::csm_packages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.2.0'}=['csm.core','csm.dsh','csm.server','csm.gui.dcem'];
$::csm_packages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.3.0'}=['csm.core','csm.dsh','csm.server','csm.diagnostics','csm.gui.dcem'];
$::csm_packages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.3.0'}=['csm.core','csm.dsh','csm.server','csm.diagnostics','csm.gui.dcem'];
$::csm_packages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.3.0'}=['csm.core','csm.dsh','csm.server','csm.diagnostics','csm.gui.dcem'];

# AIX

$::csm_packages{'MgmtSvr'}{'AIX5.1'}{'1.1.0'}=['csm.core','csm.dsh','csm.server','csm.gui.dcem','csm.gui.websm'];
$::csm_packages{'MgmtSvr'}{'AIX5.1.0'}{'1.1.0'}=['csm.core','csm.dsh','csm.server','csm.gui.dcem','csm.gui.websm'];
$::csm_packages{'MgmtSvr'}{'AIX5.1'}{'1.3.0'}=['csm.core','csm.dsh','csm.server','csm.diagnostics','csm.gui.dcem','csm.gui.websm'];
$::csm_packages{'MgmtSvr'}{'AIX5.1.0'}{'1.3.0'}=['csm.core','csm.dsh','csm.server','csm.diagnostics','csm.gui.dcem','csm.gui.websm'];

# we add the *'s to the end of the images, because AIX puts the VRMF's
# after the image. 

$::csm_packages{'MgmtSvr'}{'AIX5.2'}{'1.3.0'}=['csm.core*','csm.dsh*','csm.server*','csm.diagnostics*','csm.gui.dcem*','csm.gui.websm*','csm.msg.*_*'];
$::csm_packages{'MgmtSvr'}{'AIX5.2.0'}{'1.3.0'}=['csm.core*','csm.dsh*','csm.server*','csm.diagnostics*','csm.gui.dcem*','csm.gui.websm*', 'csm.msg.*_*'];

$::director_packages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.2.0'}=[];
$::director_packages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.2.0'}=[];
$::director_packages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.2.0'}=[];
$::director_packages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.3.0'}=['csm.director.agent','csm.director.server','csm.director.console'];
$::director_packages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.3.0'}=['csm.director.agent','csm.director.server','csm.director.console'];
$::director_packages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.3.0'}=['csm.director.agent','csm.director.server','csm.director.console'];

#####################################################################
# Management Server rsct & csm uninstall packages
# assigning $rsct_unpackages/$csm_unpackages{<MgmtSvr>}{<oslevel&version>}
#			{<fileset version>}=[<List of prerequists>]
# RSCT Packages to uninstall from the Management Server
#####################################################################

# Linux

$::rsct_unpackages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.2.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.2.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.2.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.3.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.3.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.3.0'}=['src','rsct.core.utils','rsct.core'];

# AIX

$::rsct_unpackages{'MgmtSvr'}{'AIX5.1'}{'1.1.0'}=[];
$::rsct_unpackages{'MgmtSvr'}{'AIX5.1.0'}{'1.1.0'}=[];
$::rsct_unpackages{'MgmtSvr'}{'AIX5.1'}{'1.3.0'}=[];
$::rsct_unpackages{'MgmtSvr'}{'AIX5.1.0'}{'1.3.0'}=[];
$::rsct_unpackages{'MgmtSvr'}{'AIX5.2'}{'1.3.0'}=[];
$::rsct_unpackages{'MgmtSvr'}{'AIX5.2.0'}{'1.3.0'}=[];

#####################################################################
# RSCT Packages to uninstall from the Nodes
#####################################################################

# Linux

$::rsct_unpackages{'MgdNode'}{'LinuxRedHat7.3'}{'1.2.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgdNode'}{'LinuxRedHat7.2'}{'1.2.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgdNode'}{'LinuxRedHat7.1'}{'1.2.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgdNode'}{'LinuxRedHat7.3'}{'1.3.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgdNode'}{'LinuxRedHat7.2'}{'1.3.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_unpackages{'MgdNode'}{'LinuxRedHat7.1'}{'1.3.0'}=['src','rsct.core.utils','rsct.core'];

# AIX

$::rsct_unpackages{'MgdNode'}{'AIX5.1'}{'1.1.0'}=[];
$::rsct_unpackages{'MgdNode'}{'AIX5.1.0'}{'1.1.0'}=[];
$::rsct_unpackages{'MgdNode'}{'AIX5.1'}{'1.3.0'}=[];
$::rsct_unpackages{'MgdNode'}{'AIX5.1.0'}{'1.3.0'}=[];
$::rsct_unpackages{'MgdNode'}{'AIX5.2'}{'1.3.0'}=[];
$::rsct_unpackages{'MgdNode'}{'AIX5.2.0'}{'1.3.0'}=[];


#####################################################################
# CSM Packages to uninstall from the Management Server
#####################################################################

$::csm_unpackages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.2.0'}=['csm.dsh','csm.server','csm.gui.dcem'];
$::csm_unpackages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.2.0'}=['csm.dsh','csm.server','csm.gui.dcem'];
$::csm_unpackages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.2.0'}=['csm.dsh','csm.server','csm.gui.dcem'];
$::csm_unpackages{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.3.0'}=['csm.dsh','csm.director.agent','csm.server','csm.diagnostics','csm.gui.dcem'];
$::csm_unpackages{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.3.0'}=['csm.dsh','csm.director.agent','csm.server','csm.diagnostics','csm.gui.dcem'];
$::csm_unpackages{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.3.0'}=['csm.dsh','csm.director.agent','csm.server','csm.diagnostics','csm.gui.dcem'];


# There is no mgmtsvr on AIX5.1 1.1.0
$::csm_unpackages{'MgmtSvr'}{'AIX5.1'}{'1.1.0'}=[];
$::csm_unpackages{'MgmtSvr'}{'AIX5.1.0'}{'1.1.0'}=[];
$::csm_unpackages{'MgmtSvr'}{'AIX5.1'}{'1.3.0'}=['csm.dsh','csm.server','csm.diagnostics','csm.gui.dcem', 'csm.gui.websm'];
$::csm_unpackages{'MgmtSvr'}{'AIX5.1.0'}{'1.3.0'}=['csm.dsh','csm.server','csm.diagnostics','csm.gui.dcem', 'csm.gui.websm'];
$::csm_unpackages{'MgmtSvr'}{'AIX5.2'}{'1.3.0'}=['csm.dsh','csm.server','csm.diagnostics','csm.gui*', 'csm.msg.*server*', 'csm.msg.*gui*', 'csm.msg.*diagnostics'];
$::csm_unpackages{'MgmtSvr'}{'AIX5.2.0'}{'1.3.0'}=['csm.dsh','csm.server','csm.diagnostics','csm.gui*', 'csm.msg.*server*', 'csm.msg.*gui*', 'csm.msg.*diagnostics'];


#####################################################################
# CSM Packages to uninstall from the Nodes
#####################################################################

$::csm_unpackages{'MgdNode'}{'LinuxRedHat7.3'}{'1.2.0'}=['csm.core','csm.client'];
$::csm_unpackages{'MgdNode'}{'LinuxRedHat7.2'}{'1.2.0'}=['csm.core','csm.client'];
$::csm_unpackages{'MgdNode'}{'LinuxRedHat7.1'}{'1.2.0'}=['csm.core','csm.client'];
$::csm_unpackages{'MgdNode'}{'AIX5.1'}{'1.1.0'}=[];
$::csm_unpackages{'MgdNode'}{'AIX5.1.0'}{'1.1.0'}=[];

$::csm_unpackages{'MgdNode'}{'LinuxRedHat7.3'}{'1.3.0'}=['csm.core','csm.director.agent','csm.diagnostics','csm.client'];
$::csm_unpackages{'MgdNode'}{'LinuxRedHat7.2'}{'1.3.0'}=['csm.core','csm.director.agent','csm.diagnostics','csm.client'];
$::csm_unpackages{'MgdNode'}{'LinuxRedHat7.1'}{'1.3.0'}=['csm.core','csm.director.agent','csm.diagnostics','csm.client'];
$::csm_unpackages{'MgdNode'}{'AIX5.1'}{'1.3.0'}=[];
$::csm_unpackages{'MgdNode'}{'AIX5.1.0'}{'1.3.0'}=[];
$::csm_unpackages{'MgdNode'}{'AIX5.2'}{'1.3.0'}=[];
$::csm_unpackages{'MgdNode'}{'AIX5.2.0'}{'1.3.0'}=[];


#####################################################################
# CSM directories to uninstall 
#####################################################################

# RedHat/CSM 1.2

$::csmUnistallList_dir{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.2.0'}=['/csminstall','/cfmroot'];
$::csmUnistallList_dir{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.2.0'}=['/csminstall','/cfmroot'];
$::csmUnistallList_dir{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.2.0'}=['/csminstall','/cfmroot'];

# AIX/CSM 1.1

$::csmUnistallList_dir{'MgmtSvr'}{'AIX5.1'}{'1.1.0'}=['/csminstall','/cfmroot'];
$::csmUnistallList_dir{'MgmtSvr'}{'AIX5.1.0'}{'1.1.0'}=['/csminstall','/cfmroot'];

# RedHat/CSM 1.3

$::csmUnistallList_dir{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.3.0'}=['/csminstall','/cfmroot'];
$::csmUnistallList_dir{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.3.0'}=['/csminstall','/cfmroot'];
$::csmUnistallList_dir{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.3.0'}=['/csminstall','/cfmroot'];

# AIX/CSM 1.3

$::csmUnistallList_dir{'MgmtSvr'}{'AIX5.1'}{'1.3.0'}=['/csminstall','/cfmroot'];
$::csmUnistallList_dir{'MgmtSvr'}{'AIX5.1.0'}{'1.3.0'}=['/csminstall','/cfmroot'];
$::csmUnistallList_dir{'MgmtSvr'}{'AIX5.2'}{'1.3.0'}=['/csminstall','/cfmroot'];
$::csmUnistallList_dir{'MgmtSvr'}{'AIX5.2.0'}{'1.3.0'}=['/csminstall','/cfmroot'];


#####################################################################
# CSM packages that were NOT uninstalled: 
#####################################################################

# NOT UNINSTALLED FROM MANAGEMENT SERVER:

# Linux:

$::csmUnistallList_pack{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.2.0'}=['csm.core'];
$::csmUnistallList_pack{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.2.0'}=['csm.core'];
$::csmUnistallList_pack{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.2.0'}=['csm.core'];
$::csmUnistallList_pack{'MgmtSvr'}{'LinuxRedHat7.3'}{'1.3.0'}=['csm.core'];
$::csmUnistallList_pack{'MgmtSvr'}{'LinuxRedHat7.2'}{'1.3.0'}=['csm.core'];
$::csmUnistallList_pack{'MgmtSvr'}{'LinuxRedHat7.1'}{'1.3.0'}=['csm.core'];

# AIX: 

$::csmUnistallList_pack{'MgmtSvr'}{'AIX5.1'}{'1.1.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgmtSvr'}{'AIX5.1.0'}{'1.1.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgmtSvr'}{'AIX5.1'}{'1.3.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgmtSvr'}{'AIX5.1.0'}{'1.3.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgmtSvr'}{'AIX5.2'}{'1.3.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgmtSvr'}{'AIX5.2.0'}{'1.3.0'}=['csm.core','csm.client'];


# NOT UNINSTALLED FROM MANAGED NODE:

# Linux:

$::csmUnistallList_pack{'MgdNode'}{'LinuxRedHat7.3'}{'1.2.0'}=[];
$::csmUnistallList_pack{'MgdNode'}{'LinuxRedHat7.2'}{'1.2.0'}=[];
$::csmUnistallList_pack{'MgdNode'}{'LinuxRedHat7.1'}{'1.2.0'}=[];
$::csmUnistallList_pack{'MgdNode'}{'LinuxRedHat7.3'}{'1.3.0'}=[];
$::csmUnistallList_pack{'MgdNode'}{'LinuxRedHat7.2'}{'1.3.0'}=[];
$::csmUnistallList_pack{'MgdNode'}{'LinuxRedHat7.1'}{'1.3.0'}=[];

# AIX:

$::csmUnistallList_pack{'MgdNode'}{'AIX5.1'}{'1.1.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgdNode'}{'AIX5.1.0'}{'1.1.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgdNode'}{'AIX5.1'}{'1.3.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgdNode'}{'AIX5.1.0'}{'1.3.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgdNode'}{'AIX5.2'}{'1.3.0'}=['csm.core','csm.client'];
$::csmUnistallList_pack{'MgdNode'}{'AIX5.2.0'}{'1.3.0'}=['csm.core','csm.client'];




#####################################################################
# Managed Node  rsct & csm packages
# assigning $rsct_packages{<MgdNode>}{<oslevel&version>}{<fileset version>}
#					=[<List of prerequists>]
#####################################################################

# Linux:

$::rsct_packages{'MgdNode'}{'LinuxRedHat7.3'}{'1.2.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgdNode'}{'LinuxRedHat7.2'}{'1.2.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgdNode'}{'LinuxRedHat7.1'}{'1.2.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgdNode'}{'LinuxRedHat7.3'}{'1.3.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgdNode'}{'LinuxRedHat7.2'}{'1.3.0'}=['src','rsct.core.utils','rsct.core'];
$::rsct_packages{'MgdNode'}{'LinuxRedHat7.1'}{'1.3.0'}=['src','rsct.core.utils','rsct.core'];

# AIX:

$::rsct_packages{'MgdNode'}{'AIX5.1'}{'1.1.0'}=[];
$::rsct_packages{'MgdNode'}{'AIX5.1.0'}{'1.1.0'}=[];
$::rsct_packages{'MgdNode'}{'AIX5.1'}{'1.3.0'}=[];
$::rsct_packages{'MgdNode'}{'AIX5.1.0'}{'1.3.0'}=[];
$::rsct_packages{'MgdNode'}{'AIX5.2'}{'1.3.0'}=[];
$::rsct_packages{'MgdNode'}{'AIX5.2.0'}{'1.3.0'}=[];



#####################################################################
# Managed Node csm packages
# assigning $csm_packages{<MgdNode>}{<oslevel&version>}{<fileset version>}
# 					=[<List of prerequists>]
#####################################################################

# Linux:

$::csm_packages{'MgdNode'}{'LinuxRedHat7.3'}{'1.2.0'}=['csm.core','csm.client'];
$::csm_packages{'MgdNode'}{'LinuxRedHat7.2'}{'1.2.0'}=['csm.core','csm.client'];
$::csm_packages{'MgdNode'}{'LinuxRedHat7.1'}{'1.2.0'}=['csm.core','csm.client'];
$::csm_packages{'MgdNode'}{'LinuxRedHat7.3'}{'1.3.0'}=['csm.core','csm.client','csm.diagnostics'];
$::csm_packages{'MgdNode'}{'LinuxRedHat7.2'}{'1.3.0'}=['csm.core','csm.client','csm.diagnostics'];
$::csm_packages{'MgdNode'}{'LinuxRedHat7.1'}{'1.3.0'}=['csm.core','csm.client','csm.diagnostics'];

# AIX:

# This is used by copycsmpackages.  Since gencopy places extra
# characters after the fileset name, we put the * to handle this
# case.  This potentially could cause problems elsewhere.

$::csm_packages{'MgdNode'}{'AIX5.1'}{'1.1.0'}=['csm.core*',
			    'csm.client*','csm.diagnostics*'];
$::csm_packages{'MgdNode'}{'AIX5.1.0'}{'1.1.0'}=['csm.core*',
			    'csm.client*','csm.diagnostics*'];
$::csm_packages{'MgdNode'}{'AIX5.1'}{'1.3.0'}=['csm.core*',
			    'csm.client*','csm.diagnostics*'];
$::csm_packages{'MgdNode'}{'AIX5.1.0'}{'1.3.0'}=['csm.core*',
			    'csm.client*','csm.diagnostics*'];

$::csm_packages{'MgdNode'}{'AIX5.2'}{'1.3.0'}=['csm.core*',
			    'csm.client*','csm.diagnostics*',
			    'csm.dsh*','csm.msg.*_*'];
$::csm_packages{'MgdNode'}{'AIX5.2.0'}{'1.3.0'}=['csm.core*',
			    'csm.client*','csm.diagnostics*',
			    'csm.dsh*','csm.msg.*_*'];


#####################################################################
# Director packages are Linux only 
#####################################################################

$::director_packages{'MgdNode'}{'LinuxRedHat7.3'}{'1.2.0'}=[];
$::director_packages{'MgdNode'}{'LinuxRedHat7.2'}{'1.2.0'}=[];
$::director_packages{'MgdNode'}{'LinuxRedHat7.1'}{'1.2.0'}=[];
$::director_packages{'MgdNode'}{'LinuxRedHat7.3'}{'1.3.0'}=['csm.director.agent','csm.director.server','csm.director.console'];
$::director_packages{'MgdNode'}{'LinuxRedHat7.2'}{'1.3.0'}=['csm.director.agent','csm.director.server','csm.director.console'];
$::director_packages{'MgdNode'}{'LinuxRedHat7.1'}{'1.3.0'}=['csm.director.agent','csm.director.server','csm.director.console'];


#####################################################################
# Csm binaries copied to /csminstall/csm directory
# assigning $csm_bin_copy_csm{<oslevel&version>}{<fileset version>}
#				=[<List of prerequists>]
#####################################################################

# Linux:

$::csm_bin_copy_csm{'LinuxRedHat7.3'}{'1.2.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/bin/setupconsole','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/usr/bin/atftp'];

$::csm_bin_copy_csm{'LinuxRedHat7.2'}{'1.2.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/bin/setupconsole','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/usr/bin/atftp'];

$::csm_bin_copy_csm{'LinuxRedHat7.1'}{'1.2.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/bin/setupconsole','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/usr/bin/atftp'];

$::csm_bin_copy_csm{'LinuxRedHat7.3'}{'1.3.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/bin/setupconsole','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/usr/bin/atftp'];

$::csm_bin_copy_csm{'LinuxRedHat7.2'}{'1.3.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/bin/setupconsole','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/usr/bin/atftp'];

$::csm_bin_copy_csm{'LinuxRedHat7.1'}{'1.3.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/bin/setupconsole','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/usr/bin/atftp'];


# AIX:

$::csm_bin_copy_csm{'AIX5.1'}{'1.1.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot'];

$::csm_bin_copy_csm{'AIX5.1.0'}{'1.1.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot'];

$::csm_bin_copy_csm{'AIX5.1'}{'1.3.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot'];

$::csm_bin_copy_csm{'AIX5.1.0'}{'1.3.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot'];

$::csm_bin_copy_csm{'AIX5.2'}{'1.3.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot'];

$::csm_bin_copy_csm{'AIX5.2.0'}{'1.3.0'}=['/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/pm/NodeUtils.pm','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/nodecmds.NodeUtils.map','/opt/csm/csmbin/rmnode.client','/opt/csm/csmbin/makenode','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot'];



#####################################################################
# Csm binaries copied to /tftpboot directory
# assigning $csm_bin_copy_tftpboot{<oslevel&version>}{<fileset version>}
#				  =[<List of prerequists>]
#####################################################################

# Linux:

$::csm_bin_copy_tftpboot{'LinuxRedHat7.3'}{'1.2.0'}=['/usr/lib/syslinux/pxelinux.0'];
$::csm_bin_copy_tftpboot{'LinuxRedHat7.2'}{'1.2.0'}=['/usr/lib/syslinux/pxelinux.0'];
$::csm_bin_copy_tftpboot{'LinuxRedHat7.1'}{'1.2.0'}=['/usr/lib/syslinux/pxelinux.0'];
$::csm_bin_copy_tftpboot{'LinuxRedHat7.3'}{'1.3.0'}=['/usr/lib/syslinux/pxelinux.0'];
$::csm_bin_copy_tftpboot{'LinuxRedHat7.2'}{'1.3.0'}=['/usr/lib/syslinux/pxelinux.0'];
$::csm_bin_copy_tftpboot{'LinuxRedHat7.1'}{'1.3.0'}=['/usr/lib/syslinux/pxelinux.0'];

# AIX: 

$::csm_bin_copy_tftpboot{'AIX5.1'}{'1.1.0'}=[];
$::csm_bin_copy_tftpboot{'AIX5.1.0'}{'1.1.0'}=[];
$::csm_bin_copy_tftpboot{'AIX5.1'}{'1.3.0'}=[];
$::csm_bin_copy_tftpboot{'AIX5.1.0'}{'1.3.0'}=[];
$::csm_bin_copy_tftpboot{'AIX5.2'}{'1.3.0'}=[];
$::csm_bin_copy_tftpboot{'AIX5.2.0'}{'1.3.0'}=[];

#####################################################################
# Csm binaries copied to /csminstall/csm/<csmVersion> directory
# There are no longer any version specific tools to copy.  Everything
# is in /csminstall/csm.  The kickstart files are still in 
# /csminstall/csm/<csmVersion>/<RedHatVersion>, so don't remove the
# <csmVersion> directory.
# assigning $csm_bin_copy_csmver{<oslevel&version>}{<fileset version>}
#				=[<List of prerequists>]
#####################################################################

# Linux:

$::csm_bin_copy_csmver{'LinuxRedHat7.3'}{'1.2.0'}=[];
$::csm_bin_copy_csmver{'LinuxRedHat7.2'}{'1.2.0'}=[];
$::csm_bin_copy_csmver{'LinuxRedHat7.1'}{'1.2.0'}=[];
$::csm_bin_copy_csmver{'LinuxRedHat7.3'}{'1.3.0'}=[];
$::csm_bin_copy_csmver{'LinuxRedHat7.2'}{'1.3.0'}=[];
$::csm_bin_copy_csmver{'LinuxRedHat7.1'}{'1.3.0'}=[];

# AIX:

$::csm_bin_copy_csmver{'AIX5.1'}{'1.1.0'}=[];
$::csm_bin_copy_csmver{'AIX5.1.0'}{'1.1.0'}=[];
$::csm_bin_copy_csmver{'AIX5.1'}{'1.3.0'}=[];
$::csm_bin_copy_csmver{'AIX5.1.0'}{'1.3.0'}=[];
$::csm_bin_copy_csmver{'AIX5.2'}{'1.3.0'}=[];
$::csm_bin_copy_csmver{'AIX5.2.0'}{'1.3.0'}=[];


#####################################################################
# BEGIN OBSOLETE VARIABLES
#####################################################################

# Linux:

$::csm_bin_copyfiles{'LinuxRedHat7.3'}{'1.2.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/usr/bin/atftp','/usr/lib/syslinux/pxelinux.0','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'LinuxRedHat7.2'}{'1.2.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/usr/bin/atftp','/usr/lib/syslinux/pxelinux.0','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'LinuxRedHat7.1'}{'1.2.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/usr/bin/atftp','/usr/lib/syslinux/pxelinux.0','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'LinuxRedHat7.3'}{'1.3.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/usr/bin/atftp','/usr/lib/syslinux/pxelinux.0','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'LinuxRedHat7.2'}{'1.3.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/usr/bin/atftp','/usr/lib/syslinux/pxelinux.0','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'LinuxRedHat7.1'}{'1.3.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/usr/bin/atftp','/usr/lib/syslinux/pxelinux.0','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

# AIX:

$::csm_bin_copyfiles{'AIX5.1'}{'1.1.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'AIX5.1.0'}{'1.1.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'AIX5.1'}{'1.3.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'AIX5.1.0'}{'1.3.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'AIX5.2'}{'1.3.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csm_bin_copyfiles{'AIX5.2.0'}{'1.3.0'}=['/opt/csm/csmbin/makenode','/opt/csm/pm/NodeUtils.pm','/opt/csm/bin/csmsetup.pm','/opt/csm/csmbin/updatenode.client','/opt/csm/csmbin/csmprereboot','/opt/csm/csmbin/csmfirstboot','/opt/csm/pm/InstallUtils.pm','/opt/csm/pm/InstallDefs.pm','/opt/csm/msgmaps/csmInstall.csminstall.map','/opt/csm/csmbin/write_status','/opt/csm/msgmaps/nodecmds.NodeUtils.map'];


#####################################################################
# END OBSOLETE VARIABLES
#####################################################################


#####################################################################
# OS pre-requisites for the CSM
# assigning $Linux_os_prereqs{<oslevel&version>}=[<List of prerequists>]
#####################################################################

# Linux:
$::Linux_os_prereqs{'LinuxRedHat7.3'}=['libstdc++-*','perl-5*','nfs-utils-*','pdksh-*','dhcp-*','rdist-6*','expect-5.32*','tcl-8.3*','tk-8.3*','XFree86-libs-4.2*','freetype-2.0*'];
$::Linux_os_prereqs{'LinuxRedHat7.2'}=['libstdc++-*','perl-5*','nfs-utils-*','pdksh-*','dhcp-*','rdist-6*','expect-5.32*','tcl-8.3*','tk-8.3*','XFree86-libs-4.1*','freetype-2.0*'];
$::Linux_os_prereqs{'LinuxRedHat7.1'}=['libstdc++-*','perl-5*','nfs-utils-*','pdksh-*','dhcp-*','rdist-6*','expect-5.31*','tcl-8.3*','tk-8.3*','XFree86-libs-4.0*','freetype-2.0*'];

# AIX:

$::Linux_os_prereqs{'AIX5.1'}=[];
$::Linux_os_prereqs{'AIX5.1.0'}=[];
$::Linux_os_prereqs{'AIX5.2'}=[];
$::Linux_os_prereqs{'AIX5.2.0'}=[];


#####################################################################
# Log files of CSM Management server  ( used while uninstalling)
# assigning $logfiles{'MgmtSvr'}{<oslevel&version>}=[<List of prerequists>]
#####################################################################

# Linux

$::logfiles{'MgmtSvr'}{'LinuxRedHat7.1'}=['/var/log/csm/csmsetupks.log*','/var/log/csm/installnode.log*','/var/log/csm/updatenode.log*','/var/log/csm/installms.log*'];

$::logfiles{'MgmtSvr'}{'LinuxRedHat7.3'}=['/var/log/csm/csmsetupks.log*','/var/log/csm/installnode.log*','/var/log/csm/updatenode.log*','/var/log/csm/installms.log*'];
$::logfiles{'MgmtSvr'}{'LinuxRedHat7.2'}=['/var/log/csm/csmsetupks.log*','/var/log/csm/installnode.log*','/var/log/csm/updatenode.log*','/var/log/csm/installms.log*'];

# AIX

$::logfiles{'MgmtSvr'}{'AIX5.1'}=['/var/log/csm/updatenode.log*','/var/log/csm/installms.log*'];
$::logfiles{'MgmtSvr'}{'AIX5.1.0'}=['/var/log/csm/updatenode.log*','/var/log/csm/installms.log*'];

$::logfiles{'MgmtSvr'}{'AIX5.2'}=['/var/log/csm/updatenode.log*','/var/log/csm/installms.log*'];
$::logfiles{'MgmtSvr'}{'AIX5.2.0'}=['/var/log/csm/updatenode.log*','/var/log/csm/installms.log*'];


#####################################################################
# Log files of CSM Managed Node  ( used while uninstalling)
# assigning $logfiles{'MgdNode'}{<oslevel&version>}=[<List of prerequists>]
#####################################################################

# Linux:

$::logfiles{'MgdNode'}{'LinuxRedHat7.1'}=['/var/log/csm/install.log*','/var/opt/csm/cfmlocal*'];
$::logfiles{'MgdNode'}{'LinuxRedHat7.2'}=['/var/log/csm/install.log*','/var/opt/csm/cfmlocal*'];
$::logfiles{'MgdNode'}{'LinuxRedHat7.3'}=['/var/log/csm/install.log*','/var/opt/csm/cfmlocal*'];

# AIX

$::logfiles{'MgdNode'}{'AIX5.1'}=['/var/log/csm/install.log*','/var/opt/csm/cfmlocal*'];
$::logfiles{'MgdNode'}{'AIX5.1.0'}=['/var/log/csm/install.log*','/var/opt/csm/cfmlocal*'];
$::logfiles{'MgdNode'}{'AIX5.2'}=['/var/log/csm/install.log*','/var/opt/csm/cfmlocal*'];
$::logfiles{'MgdNode'}{'AIX5.2.0'}=['/var/log/csm/install.log*','/var/opt/csm/cfmlocal*'];

#####################################################################
# BEGIN OBSOLETE VARIABLES
#####################################################################

#####################################################################
# Files that need to extraced from CSM.Core package (Used for copycsmpkgs)
# assigning $csmbin{'csm.core'}{<oslevel&version>}{<fileset version>}
#						=[<List of prerequists>]
#####################################################################

# Linux

$::csmbin{'csm.core'}{'LinuxRedHat7.1'}{'1.2.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'LinuxRedHat7.2'}{'1.2.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'LinuxRedHat7.3'}{'1.2.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'LinuxRedHat7.1'}{'1.3.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'LinuxRedHat7.2'}{'1.3.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'LinuxRedHat7.3'}{'1.3.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];


# AIX

$::csmbin{'csm.core'}{'AIX5.1'}{'1.1.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'AIX5.1.0'}{'1.1.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'AIX5.1'}{'1.3.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'AIX5.1.0'}{'1.3.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'AIX5.2'}{'1.3.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

$::csmbin{'csm.core'}{'AIX5.2.0'}{'1.3.0'}=['opt/csm/pm/NodeUtils.pm','opt/csm/bin/csmsetup.pm','opt/csm/pm/InstallUtils.pm','opt/csm/pm/InstallDefs.pm','opt/csm/msgmaps/csmInstall.csminstall.map','opt/csm/msgmaps/nodecmds.NodeUtils.map'];

#####################################################################
# Files that need to extraced from CSM.Server package (Used for copycsmpkgs)
# assigning $csmbin{'csm.server'}{<oslevel&version>}{<fileset version>}
#					=[<List of prerequists>]
#####################################################################

# Linux

$::csmbin{'csm.server'}{'LinuxRedHat7.1'}{'1.2.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'LinuxRedHat7.2'}{'1.2.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'LinuxRedHat7.3'}{'1.2.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'LinuxRedHat7.1'}{'1.3.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'LinuxRedHat7.2'}{'1.3.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'LinuxRedHat7.3'}{'1.3.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];

# AIX

$::csmbin{'csm.server'}{'AIX5.1'}{'1.1.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'AIX5.1.0'}{'1.1.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'AIX5.1'}{'1.3.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'AIX5.1.0'}{'1.3.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'AIX5.2'}{'1.3.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];
$::csmbin{'csm.server'}{'AIX5.2.0'}{'1.3.0'}=['opt/csm/csmbin/makenode','opt/csm/csmbin/csmprereboot','opt/csm/csmbin/csmfirstboot'];

#####################################################################
# File that need to extraced from open source package (Used for copycsmpkgs)
# assigning $csmbinOpenSrc{'opensrc'}{<oslevel&version>}{<fileset version>}
#					=[<List of prerequists>]
#####################################################################

# Linux

$::csmbin{'opensrc'}{'LinuxRedHat7.1'}{'1.2.0'}=['usr/bin/atftp'];
$::csmbin{'opensrc'}{'LinuxRedHat7.2'}{'1.2.0'}=['usr/bin/atftp'];
$::csmbin{'opensrc'}{'LinuxRedHat7.3'}{'1.2.0'}=['usr/bin/atftp'];
$::csmbin{'opensrc'}{'LinuxRedHat7.1'}{'1.3.0'}=['usr/bin/atftp'];
$::csmbin{'opensrc'}{'LinuxRedHat7.2'}{'1.3.0'}=['usr/bin/atftp'];
$::csmbin{'opensrc'}{'LinuxRedHat7.3'}{'1.3.0'}=['usr/bin/atftp'];

# AIX

$::csmbin{'opensrc'}{'AIX5.1'}{'1.1.0'}=[];
$::csmbin{'opensrc'}{'AIX5.1.0'}{'1.1.0'}=[];
$::csmbin{'opensrc'}{'AIX5.1'}{'1.3.0'}=[];
$::csmbin{'opensrc'}{'AIX5.1.0'}{'1.3.0'}=[];
$::csmbin{'opensrc'}{'AIX5.2'}{'1.3.0'}=[];
$::csmbin{'opensrc'}{'AIX5.2.0'}{'1.3.0'}=[];

#####################################################################
# END OBSOLETE VARIABLES
#####################################################################

1;  # end

